package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.SeckillActivitySiteCountDetailConfigDto;

import java.util.List;

/**
 * 秒杀活动场次详情配置表
 * @author kjj mybatis generator 
 * @date 2024-07-10
 */
@AdvancedFeignClient
public interface RemoteSeckillActivitySiteCountDetailConfigService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 秒杀活动场次详情配置
     */
    SeckillActivitySiteCountDetailConfigDto selectById(Long id);

    /**
     * 新增
     * @param dto 秒杀活动场次详情配置
     * @return 执行结果
     */
    int insert(SeckillActivitySiteCountDetailConfigDto dto);

    /**
     * 更新
     * @param dto 秒杀活动场次详情配置
     * @return 影响行数
     */
    int update(SeckillActivitySiteCountDetailConfigDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据主键查询
     *
     * @param activityId 活动 id
     * @return 秒杀活动场次详情配置
     */
    List<SeckillActivitySiteCountDetailConfigDto> selectByActivityId(Long activityId);
}