package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 活动表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityDto implements Serializable {

    private static final long serialVersionUID = -2099354813835529791L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 背景图片
     */
    private String backgroundImg;

    /**
     * 小程序分享图
     */
    private String mpShareImg;

    /**
     * 按钮颜色
     */
    private String buttonColor;

    /**
     * 海报
     */
    private String sharePoster;

    /**
     * 客户经理端列表展示图
     */
    private String staffListImg;

    /**
     * 是否需要支付，0-否，1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needPay;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 是否限制银行卡，0-否，1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needLimitBank;

    /**
     * 限制的银行卡编码，以英文逗号分隔
     */
    private String limitBanks;

    /**
     * 是否退款，0-否，1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer needRefund;

    /**
     * 活动规则
     */
    private String activityRules;

    /**
     * 是否启用, 0-停用, 1-启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer activityStatus;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 客户经理海报
     */
    private String sharePosterStaff;

    /**
     * 管理员海报
     */
    private String sharePosterAdmin;

    /**
     * 支付类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String payChannelType;

    /**
     * 领奖限制：1-限领一次，2-可领多次
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActPrizeTakeNumLimitTypeEnum#getType()
     */
    private Integer takeNumLimitType;

    /**
     * 是否限制领取次数：0-不限制，1-限制
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer actTakeLimitType;

    /**
     * 活动纬度可领取次数上限
     */
    private Long actTakeNum;

    /**
     * 领取类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.TakeTypeEnum
     */
    private Integer takeType;

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 扩展信息
     */
    private List<ActivityExtDto> activityExtDtos;

    /**
     * 订阅物流
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer subExpress;
}