package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 秒杀活动场次配置表
 * @author mybatis generator 
 * @date 2024-07-10
 */
@Data
public class SeckillActivitySiteCountConfigDto implements Serializable {
     
    private static final long serialVersionUID = 17205817363122112L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 场次类型 0单场次 1多场次
     */
    private Integer siteCountType;

    /**
     * 循环维度 0 按天 1 按周 2 按月
     */
    private Integer circulateType;

    /**
     * 周限制时间，格式为 1,2,3,4 1表示周一，7表示周日
     */
    private String weekLimitByDay;

    /**
     * 月限制配置-开始时间
     */
    private Integer monthStartTime;

    /**
     * 月限制配置-结束时间
     */
    private Integer monthEndTime;

    /**
     * 开始时间，活动有效期
     */
    private Date startTime;

    /**
     * 结束时间，活动有效期
     */
    private Date endTime;
}