package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/5/11 11:48
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CashierFullDiscountAutoCreateExtInfoDto extends WxCouponAutoCreateExtInfoDto {
    private static final long serialVersionUID = -4040256071487773393L;

    /**
     * 折扣率
     */
    private String discountRate;

    /**
     * 门槛金额（元）
     */
    private String useThreshold;

    /**
     * 单笔优惠上限（元）
     */
    private String upperLimit;

    /**
     * 随机立减规则（格式：[{"startRange":"0","endRange":"100","amount":"10"},{"startRange":"100","endRange":"200","amount":"20"}]）
     */
    private String discountAmountRules;

    /**
     * 活动开始时间
     */
    private String beginTime;

    /**
     * 活动结束时间
     */
    private String endTime;

    /**
     * 有效日期段 1-全部 2-有效期内，规则日期可用 3-有效期内 不规则日期可用
     */
    private Integer periodType;

    /**
     * 星期规则 类型为2时必填 格式：[1,1,1,1,1,1,1] 1-选中 0-不选中
     */
    private List<Integer> weekDay;

    /**
     * 24小时制时段，类型为2|3时必填，格式：00:00-18:00，最长3段
     */
    private List<String> hour24Range;

    /**
     * 日期段，类型为3时必填，格式：2024-04-15&2024-04-17
     */
    private List<String> dateRange;

    /**
     * 用户领取次数
     */
    private Integer userReceiveTimes;

    /**
     * 用户每日优惠次数限制
     */
    private Integer userDayLimit;

    /**
     * 是否开启自然人拦截(1-开启 2-关闭)
     */
    private Integer useNaturalDefense;

    /**
     * 活动商户号（本商户直接填写商户号）
     */
    private List<String> mchCodeList;

    /**
     * 活动预算（元）
     */
    private String budgetAmount;

    /**
     * 单天消耗预算，指定时为设置单天预算消耗上限
     */
    private String dayLimitAmount;

    /**
     * 指定支付方式（0-不限 1-银行卡 2-零钱）
     */
    private Integer directPayMethod;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行卡类型 1-借记卡 2-信用卡
     */
    private Integer cardType;

    /**
     * 卡bin描述
     */
    private String cardBinDesc;

    /**
     * 卡bin列表
     */
    private List<String> cardBinList;

    /**
     * 同时使用 (1-该优惠可以和其他优惠同时使用 2-该优惠不可以和本商户号创建的其他立减/折扣同时使用（但可以享受优惠券）)
     */
    private Integer bothUse;
    /**
     * 支付方式
     * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.WxCouponPaySceneEnum}
     */
    private List<Integer> payScene;

    /**
     * 订单优惠标记，数组单项值「只支持英文、数字及下划线(_)；长度32；不可重复」，可不指定
     */
    private List<String> discountTags;
}
