package cn.com.duiba.quanyi.center.api.remoteservice.insurance.land;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.land.InsuranceLandEquityDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceLandEquityEsSearchParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceLandEquitySearchParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 大地保险权益表
 *
 * @author kjj mybatis generator
 * @date 2024-06-25
 */
@AdvancedFeignClient
public interface RemoteInsuranceLandEquityService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 大地保险权益集合
     */
    List<InsuranceLandEquityDto> selectPage(InsuranceLandEquitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceLandEquitySearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 大地保险权益
     */
    InsuranceLandEquityDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 大地保险权益
     * @return 执行结果
     */
    int insert(InsuranceLandEquityDto dto);

    /**
     * 批量插入
     *
     * @param equityDtoList 大地保险权益
     * @return 执行结果 主键ID
     */
    List<InsuranceLandEquityDto> batchInsert(List<InsuranceLandEquityDto> equityDtoList);

    /**
     * 更新
     *
     * @param dto 大地保险权益
     * @return 影响行数
     */
    int update(InsuranceLandEquityDto dto);

    /**
     * 软删
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 软删同步es
     * @param id
     * @return
     */
    boolean deleteDbSyncEs(Long id);


    /**
     * 根据代码和姓名查询
     *
     * @param param 查询条件
     * @return 大地保险权益集合
     */
    List<InsuranceLandEquityDto> selectByCodeAndName(InsuranceLandEquitySearchParam param);

    /**
     * 根据代码查询
     *
     * @param param 查询条件
     * @return 大地保险权益集合
     */
    List<InsuranceLandEquityDto> selectByCodes(InsuranceLandEquitySearchParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    PageResponse<InsuranceLandEquityDto> pageQuery(InsuranceLandEquityEsSearchParam param);
}