package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 大地保险权益表
 *
 * @author mybatis generator
 * @date 2024-06-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceLandEquitySearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17193098569038533L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 坐席手机号
     */
    private String salesmanPhone;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 坐席登录账号主键
     */
    private Long salesmanId;

    /**
     * 权益ID, tb_insurance_equity.id
     */
    private Long equityId;

    /**
     * 待领人代码
     */
    private String userCode;

    /**
     * 代领人代码集合
     */
    private List<String> userCodes;

    /**
     * 发放人姓名
     */
    private String takeName;

    /**
     * 发放人手机号
     */
    private String takePhone;

    /**
     * 卡号
     */
    private String cardNo;

    /**
     * 身份证号
     */
    private String identityCard;

    /**
     * 金额，单位分
     */
    private Long amount;

    /**
     * 发放状态：1-待发放，2-发放成功，3-发放失败
     */
    private Integer takeStatus;

    /**
     * 发放状态集合
     */
    private List<Integer> takeStatusList;

    /**
     * 错误原因
     */
    private String errorMsg;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}