package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum ActivityExtEnum {

    SUPPLY_GOODS_TYPE(1, "商品类型", false),

    SUPPLY_GRANT_TYPE(2, "供给方式", false),

    SUPPLY_LINK_TYPE(3, "链接券形式(,分割)", false),

    SUPPLY_API_JOINT_ID(4, "API对接ID", false),

    ICBC_CUSTOM_ID(5, "工行-客群id(,分割)", false),
    
    SHORT_URL_EFFECTIVE_DAYS(6, "短链有效天数", true),

    ACTIVITY_PAGE_CONFIG(7, "活动页面配置", false),
    ACTIVITY_PRIZE_CONFIG(8, "活动奖项配置", false),
    ACTIVITY_LIMIT_CONFIG(9, "活动限制配置", false),
    ACTIVITY_BACKGROUND_COLOR(12, "活动背景颜色", true),
    ACTIVITY_AUTO_TAKE(16, "活动是否自动领取", true),

    ;

    private final Integer type;

    private final String desc;

    private final boolean canDelete;

    public static boolean getEnumByCanDelete(Integer type) {
        for (ActivityExtEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.isCanDelete();
            }
        }
        return false;
    }

}
