package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 大地保险用户认证信息表
 * @author mybatis generator 
 * @date 2024-06-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceLandAuthInfoSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17194601544992851L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 用户ID，tb_user.id
     */
    private Long userId;

    /**
     * 待领人代码
     */
    private String userCode;

    /**
     * 发放人姓名
     */
    private String takeName;

    /**
     * 发放人手机号
     */
    private String takePhone;

    /**
     * 身份证号
     */
    private String identityCard;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}