package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.DemandGoodsStatisticDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.DemandGoodsStatisticSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 需求商品统计表
 * @author kjj mybatis generator 
 * @date 2024-07-18
 */
@AdvancedFeignClient
public interface RemoteDemandGoodsStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 需求商品统计集合
     */
    List<DemandGoodsStatisticDto> selectPage(DemandGoodsStatisticSearchParam param);

    /**
     * 根据时间查询需求商品列表
     *
     * @param startDate      开始时间
     * @param endDate        结束时间
     * @param goodsParamList 需求商品列表
     * @return 需求商品列表
     */
    List<DemandGoodsStatisticDto> selectByDemandGoodsIdAndDate(Date startDate, Date endDate, List<DemandGoodsStatisticSearchParam> goodsParamList);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DemandGoodsStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 需求商品统计
     */
    DemandGoodsStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 需求商品统计
     * @return 执行结果
     */
    int insert(DemandGoodsStatisticDto dto);

    /**
     * 更新
     * @param dto 需求商品统计
     * @return 影响行数
     */
    int update(DemandGoodsStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据ID更新(只更新是否结算这个字段)
     *
     * @param idList 主键集合
     * @return 影响行数
     */
    int batchUpdateSettled(List<Long> idList);
}