package cn.com.duiba.quanyi.center.api.dto.code;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 渠道券码表
 *
 * @author kjj mybatis generator
 * @date 2023-09-14
 */
@Data
public class CodeDto implements Serializable {

    private static final long serialVersionUID = 1034947073331368826L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务类型，1-商品包制券
     *
     * @see cn.com.duiba.quanyi.center.api.enums.code.CodeBizTypeEnum
     */
    private Integer codeBizType;

    /**
     * 业务ID
     */
    private Long codeBizId;

    /**
     * 券码是否可重复使用，0-不可以，1-可以
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer canRepeated;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 券码状态，1-未使用，2-已使用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.code.CodeStatusEnum
     */
    private Integer codeStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 链接券的url
     */
    private String link;

    /**
     * 券码所绑定的参数，用于拦截非法请求
     */
    private String paramJson;
}