package cn.com.duiba.quanyi.center.api.log.operate.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 操作日志，方法注解（注意，仅适合用于流量不高的操作接口）
 * @author lizhi
 * @date 2023/5/15 6:36 PM
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface OperateLogMethod {

    /**
     * 操作所属业务名称, 比如权益、活动
     */
    String group() default "默认";

    /**
     * 操作类型名称, 比如新增、修改、删除
     */
    String type() default "";
    
}
