package cn.com.duiba.quanyi.center.api.param.mall.page;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 商城页面
 * @author mybatis generator 
 * @date 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MallPageSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17164467811511878L;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 创建人ssoId
     */
    private Long createOperatorId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 页面类型，1-首页，2-二级页面，3-我的页面
     * {@link cn.com.duiba.quanyi.center.api.enums.mall.MallPageTypeEnum}
     */
    private Integer pageType;

    /**
     * 页面标题
     */
    private String pageTitle;

    /**
     * 页面状态，0-未上架 1-上架
     * {@link cn.com.duiba.quanyi.center.api.enums.mall.MallStatusEnum}
     */
    private Integer pageStatus;
}