package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.KvDataDto;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityKvEnum;
import cn.com.duiba.quanyi.center.api.param.activity.KvDataVoSearchParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * KV数据表
 * @author kjj mybatis generator 
 * @date 2024-06-20
 */
@AdvancedFeignClient
public interface RemoteKvDataService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return KV数据集合
     */
    List<KvDataDto> selectPage(KvDataVoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(KvDataVoSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return KV数据
     */
    KvDataDto selectById(Long id);

    /**
     * 新增
     * @param dto KV数据
     * @return 执行结果
     */
    int insert(KvDataDto dto);

    /**
     * 更新
     * @param dto KV数据
     * @return 影响行数
     */
    int update(KvDataDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新StringValue 存在则更新 不存在则新增
     * @see ActivityKvEnum
     * @param key 唯一key
     * @param value 值
     * @param expire 过期时间
     * @param isRefresh true 刷新过期时间  false 不刷新
     */
    boolean setStringValue(String key, String value, Date expire, boolean isRefresh);


    /**
     * 查询数据
     *
     * @param key 唯一key
     * @return 数据结果
     */
     KvDataDto get(String key);

    /**
     * 批量查询
     *
     * @param keys 批量查询key
     * @return 结果集合
     */
    Map<String, KvDataDto> multiGet(List<String> keys);

}