package cn.com.duiba.quanyi.center.api.remoteservice.insurance.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.customer.InsuranceFundAccountDto;

import java.util.List;

/**
 * 保司资金账户表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceFundAccountService {

    /**
     * 根据公司及手机号查询
     * @param companyId 保险公司ID，tb_insurance_company.id
     * @param accountPhone 手机号
     * @return 保司资金账户
     */
    InsuranceFundAccountDto selectByCompanyPhone(Long companyId, String accountPhone);

    /**
     * 根据手机号查询
     * @param accountPhone 手机号
     * @return 保司资金账户
     */
    List<InsuranceFundAccountDto> selectByPhone(String accountPhone);

    /**
     * 根据手机号查询选择的账户
     * @param accountPhone 手机号
     * @return 保司资金账户
     */
    InsuranceFundAccountDto selectSelectedByPhone(String accountPhone);

    /**
     * 选择公司
     *
     * @param accountPhone 手机号
     * @param companyId 保险公司ID，tb_insurance_company.id
     * @return 影响行数
     */
    int selectCompany(String accountPhone, Long companyId);
}