package cn.com.duiba.quanyi.center.api.dto.api;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * API-商品信息
 * @author lizhi
 * @date 2023/12/4 20:31
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiSpecResult extends ApiBaseResult {
    
    private static final long serialVersionUID = 4372430151952159865L;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 商品名称
     */
    private String specName;

    /**
     * 可用库存（注：券包商品，取所有子商品中库存最少的一个）
     * ● 商品为微信立减金/支付宝立减金时，取商品库存与关联的第一个批次可用库存较少的一个
     * ● 其他类型商品，取商品库存
     */
    private Long availableStock;

    /**
     * 批次名称（注：券包商品，取第一个商品的）
     * ● 商品为微信立减金/支付宝立减金时，取关联的第一个批次名称
     * ● 其他类型商品为空
     */
    private String couponName;

    /**
     * 批次描述（注：券包商品，取第一个商品的）
     * ● 商品为支付宝立减金时有值
     */
    private String couponDesc;

    /**
     * 批次面额（注：券包商品，取第一个商品的）
     * ● 商品为微信立减金/支付宝立减金时，且批次为固定面额时，取关联的第一个批次的面额
     */
    private Long couponAmount;

    /**
     * 批次门槛（注：券包商品，取第一个商品的）
     * ● 商品为微信立减金/支付宝立减金时，且批次为固定面额时，取关联的第一个批次的门槛
     */
    private Long couponMinimum;

    /**
     * 批次领取后有效期类型（注：券包商品，取第一个商品的）
     * ● 商品为支付宝立减金时，取关联的第一个批次的有效期类型
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiCouponAvailableTypeEnum
     */
    private Integer availableType;

    /**
     * 批次领取后有效期-绝对时间-开始时间（注：券包商品，取第一个商品的）
     * ● 商品为支付宝立减金时，且有效期类型为绝对时间时，取关联的第一个批次的开始时间
     */
    private Date availableStartTime;

    /**
     * 批次领取后有效期-绝对时间-结束时间（注：券包商品，取第一个商品的）
     * ● 商品为支付宝立减金时，且有效期类型为绝对时间时，取关联的第一个批次的结束时间
     */
    private Date availableEndTime;

    /**
     * 批次领取后有效期-相对时间-天数（注：券包商品，取第一个商品的）
     * ● 商品为支付宝立减金时，且有效期类型为相对时间-天级别时，取关联的第一个批次的天数
     */
    private Integer availableDays;
}
