package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值
 * <p>
 * 相对时间情况下，红包发放开始时间周期类型
 * DAYS:天级
 * MINUTES:分钟级
 *
 * @see <a>https://opendocs.alipay.com/pre-apis/01trl0</>
 */
@Getter
@AllArgsConstructor
public enum AlipayCouponRelativeRoundingTypeEnum {
    DAYS("DAYS", "天级"),
    MINUTES("MINUTES", "分钟级"),
    ;

    private final String type;

    private final String desc;
}
