package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityAutoCreateTaskDto;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayActivityAutoCreateTaskSearchParam;
import java.util.List;

/**
 * 支付宝立减金自动创建批次任务表
 * @author kjj mybatis generator 
 * @date 2024-07-23
 */
@AdvancedFeignClient
public interface RemoteAlipayActivityAutoCreateTaskService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝立减金自动创建批次任务
     */
    AlipayActivityAutoCreateTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝立减金自动创建批次任务
     * @return 执行结果
     */
    int insert(AlipayActivityAutoCreateTaskDto dto);

    /**
     * 更新
     * @param dto 支付宝立减金自动创建批次任务
     * @return 影响行数
     */
    int update(AlipayActivityAutoCreateTaskDto dto);
}