package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 业务活动类型
 * 对应于领取记录表的类型
 *
 * @author zzy
 * @create 2023/10/11 11:32
 **/
@Getter
@AllArgsConstructor
public enum BizActUrlEnum {
    BAI_MING_DAN(1, "/pages/activity-manager/whitelist", "白名单领奖"),

    DUIBA_KAMI(2, "/pages/activity-manager/dbkmpkg", "兑吧卡密包"),

    API_SUPPLY(7, "/pages/activity-manager/api/activity", "API供货"),
    ;

    public static String getUrlByType(Integer type) {
        for (BizActUrlEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getUrl();
            }
        }
        return null;
    }

    private final Integer type;

    private final String url;

    private final String desc;
}
