package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponAutoAddMoneyTaskDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponStockDto;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponAutoAddMoneyTaskParam;
import cn.com.duiba.quanyi.center.api.param.coupon.notify.WxCouponAddMoneyResultNotifyParam;

import java.util.List;
import java.util.Map;

/**
 * 微信立减金加款任务结果通知
 * @author kjj mybatis generator 
 * @date 2024-03-19
 */
@AdvancedFeignClient
public interface RemoteWxCouponAddMoneyTaskService {

    /**
     * 任务结果通知
     *
     * @param notifyParams 通知参数
     */
    void taskResultNotify(List<WxCouponAddMoneyResultNotifyParam> notifyParams);

    /**
     * 查询需要加款的任务
     * @param size 数据
     * @return 任务集合
     */
    List<WxCouponAutoAddMoneyTaskDto> selectAddMoneyTaskList(Integer size);

    /**
     * 手动添加加款任务
     *
     * @param wxCoupon 微信立减金
     * @param amount 加款后金额
     * @return true-成功 false-失败
     */
    boolean createAddMoneyTask(WxCouponDto wxCoupon, Long amount);

    /**
     * 批量创建加款任务
     *
     * @param stock2AmountMap 批次id-加款后金额
     * @param couponId2StockMap 优惠券id-库存
     * @param addType 加款类型 {@link cn.com.duiba.quanyi.center.api.enums.coupon.WxCouponAutoAddMoneyTypeEnum}
     * @return 批次id-错误原因
     */
    Map<String, String> batchCreateTask(Map<WxCouponDto, Long> stock2AmountMap, Map<Long, WxCouponStockDto> couponId2StockMap, Integer addType);

    /**
     * 根据批次id查询正在进行中的任务
     * @param stockId 批次id
     * @return 微信立减金加款任务明细
     */
    WxCouponAutoAddMoneyTaskDto selectProcessingTaskByStockId(String stockId);

    /**
     * 分页查询任务明细
     *
     * @param param 查询参数
     * @return 任务明细
     */
    List<WxCouponAutoAddMoneyTaskDto> selectPageList(WxCouponAutoAddMoneyTaskParam param);

    /**
     * 查询数量
     *
     * @param param 查询参数
     * @return 数量
     */
    Long selectCount(WxCouponAutoAddMoneyTaskParam param);
}