package cn.com.duiba.quanyi.center.api.remoteservice.minsheng;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.minsheng.MinshengConsumerExchangeRecordDto;
import cn.com.duiba.quanyi.center.api.param.minsheng.MinshengConsumerExchangeRecordSearchParam;
import java.util.List;

/**
 * 民生银行用户兑换记录表
 * @author kjj mybatis generator 
 * @date 2024-07-09
 */
@AdvancedFeignClient
public interface RemoteMinshengConsumerExchangeRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 民生银行用户兑换记录集合
     */
    List<MinshengConsumerExchangeRecordDto> selectPage(MinshengConsumerExchangeRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MinshengConsumerExchangeRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 民生银行用户兑换记录
     */
    MinshengConsumerExchangeRecordDto selectById(Long id);

    /**
     * 根据券码查询
     * @param couponCode
     * @return
     */
    MinshengConsumerExchangeRecordDto selectByCouponCode(String couponCode);

    /**
     * 新增
     * @param dto 民生银行用户兑换记录
     * @return 执行结果
     */
    int insert(MinshengConsumerExchangeRecordDto dto);

    /**
     * 更新
     * @param dto 民生银行用户兑换记录
     * @return 影响行数
     */
    int update(MinshengConsumerExchangeRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 更新订单推送状态
     * @param id
     * @param originStatus
     * @param updateStatus
     * @return
     */
    boolean updatePushStatus(Long id, Integer originStatus, Integer updateStatus);
}