package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/7/25 16:06
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CardPayCutAutoCreateExtInfoDto extends AlipayActivityAutoCreateExtInfoDto {
    private static final long serialVersionUID = 122269328716626L;

    /**
     * 基础信息
     */
    private BaseInfo baseInfo;

    /**
     * 优惠信息
     */
    private DiscountInfo discountInfo;

    /**
     * 白名单测试列表
     */
    private List<String> whiteTestList;

    @Data
    public static class BaseInfo {
        /**
         * 活动名称
         */
        private String activityName;

        /**
         * 银行信息
         */
        private List<Bank> bank;

        /**
         * 银行卡bin列表
         */
        private List<String> bankCardBin;

        /**
         * 是否展示卡组织信息，多银行活动有效
         */
        private boolean showCardOrgInfo;

        /**
         * 发放时间范围 YYYY-MM-DD HH:SS:mm 格式，[开始时间, 结束时间]
         */
        private List<String> timeRange;

        /**
         * 可用时间
         */
        private EnableTime enableTime;
    }

    @Data
    public static class EnableTime {
        /**
         * 周日期, 值示例：[1,1,1,0,0,0,1]
         */
        private List<Integer> weeks;

        /**
         * 活动时间, 值示例：['08:00:00,09:00:00', '10:00:00,12:00:00']
         */
        private List<String> times;
    }

    @Data
    public static class Bank {
        /**
         * 银行名称
         */
        private String name;

        /**
         * 银行卡类型 1-借记卡 2-信用卡
         */
        private Integer cardType;
    }

    @Data
    public static class DiscountInfo {

        /**
         * 活动预算
         */
        private String budgetAmount;

        /**
         * 每日预算配置
         */
        private DayBudget dayBudget;

        /**
         * 优惠玩法类型 1-单一门槛优惠 2-阶梯门槛优惠
         */
        private Integer gamePlayType;

        /**
         * 单一门槛优惠
         */
        private GamePlaySingle gamePlaySingle;

        /**
         * 阶梯门槛优惠
         */
        private GamePlayStep gamePlayStep;

        /**
         * 参与次数限制(活动期间每个用户可参与)
         */
        private Integer receiveLimit;

        /**
         * 频率限制
         */
        private TimeLimit timeLimit;

        /**
         * 指定人群id
         */
        private String personId;

        /**
         * 预警信息
         */
        private Alarm alarm;
    }

    @Data
    public static class TimeLimit {
        /**
         * 类型，1-自然日 2-自然周 3-自然月 4-自然年
         */
        private Integer type;

        /**
         * 参与次数
         */
        private Integer num;
    }

    @Data
    public static class GamePlayStep {
        /**
         * 阶梯门槛优惠规则
         */
        private List<GamePlayRule> array;

        /**
         * 最高优惠金额
         */
        private String maxAmount;
    }

    @Data
    public static class GamePlayRule {
        /**
         * 消费门槛区间
         */
        private List<String> thresholdArea;

        /**
         * 类型，1-减至 2-定额立减
         */
        private Integer type;

        /**
         * 规则
         */
        private String rule;
    }

    @Data
    public static class GamePlaySingle {
        /**
         * 类型 1-定额立减 2-折扣立减 3-智能立减
         */
        private Integer type;
        /**
         * 消费门槛金额
         */
        private String threshold;
        /**
         * 优惠金额，类型为1时存在
         */
        private String amount;
        /**
         * 优惠规则，类型为2时存在
         */
        private String rule;
        /**
         * 单笔最高优惠金额，类型为2时存在
         */
        private String maxAmount;
        /**
         * 优惠金额均价，类型为3时存在
         */
        private String averagePrice;
        /**
         * 立减区间，类型为3时存在
         */
        private List<String> average;
    }

    @Data
    public static class DayBudget {
        /**
         * 每日预算上限类型 1-出奖金额 2-出奖份数
         */
        private Integer type;

        /**
         * 每日预算上限
         */
        private String amount;
    }

    @Data
    public static class Alarm {
        /**
         * 总预算剩余值进行预警
         */
        private String amount;

        /**
         * 预警接受appId
         */
        private List<String> appidList;
    }
}
