package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author xuzhigang
 * @date 2024/6/24 11:21
 **/
@Getter
@AllArgsConstructor
public enum WechatTagTimePeriodEnum {
    TEN_DAYS(1, "10天内"),

    THIRTY_DAYS(2, "30天内"),

    SIXTY_DAYS(3, "60天内"),

    NINETY_DAYS(4, "90天内"),
    ;

    private final int code;

    private final String desc;

    public static boolean contains(int code) {
        return Arrays.stream(values()).anyMatch(e -> e.getCode() == code);
    }
}
