package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝立减金自动创建批次任务表
 * @author mybatis generator 
 * @date 2024-07-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AlipayActivityAutoCreateTaskSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17217253711201894L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 上传任务id tb_upload_task.id
     */
    private Long uploadTaskId;

    /**
     * 支付宝应用id
     */
    private String appId;

    /**
     * 活动id 创建成功后回填
     */
    private String activityId;

    /**
     * 活动类型 1-银行卡支付立减 2-通用渠道红包 3-首绑有礼 4-多刷有礼
     */
    private Byte activityType;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动预算 单位分
     */
    private Long activityAmount;

    /**
     * 需求预算，单位分
     */
    private Long demandAmount;

    /**
     * 创建批次任务状态 0-初始化 1-创建中 2-创建成功 3-创建失败
     */
    private Byte taskStatus;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 创建人Id,ssoId
     */
    private Long creatorId;

    /**
     * 创建人名称,ssoName
     */
    private String creatorName;

    /**
     * 对应上传excel的行号
     */
    private Integer rowIndex;

    /**
     * 0-不自动加款 1-自动加款
     */
    private Byte autoAddMoney;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 创建批次额外信息 json字符串存储
     */
    private String extInfo;
}