/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon;

import cn.com.duiba.quanyi.center.api.enums.pay.BankCardTypeEnum;
import java.util.Arrays;
import java.util.Objects;

public enum WxCouponBankTypeEnum {
    DEBIT(1, "\u501f\u8bb0\u5361"),
    CREDIT(2, "\u4fe1\u7528\u5361");

    private final Integer bankType;
    private final String desc;

    public static boolean isValidType(Integer bankType) {
        return Arrays.stream(WxCouponBankTypeEnum.values()).anyMatch(t -> Objects.equals(t.getBankType(), bankType));
    }

    public static String convertBankType(Integer bankType) {
        if (Objects.equals(bankType, WxCouponBankTypeEnum.DEBIT.bankType)) {
            return BankCardTypeEnum.DEBIT.getType();
        }
        if (Objects.equals(bankType, WxCouponBankTypeEnum.CREDIT.bankType)) {
            return BankCardTypeEnum.CREDIT_DEBIT.getType();
        }
        return null;
    }

    public Integer getBankType() {
        return this.bankType;
    }

    public String getDesc() {
        return this.desc;
    }

    private WxCouponBankTypeEnum(Integer bankType, String desc) {
        this.bankType = bankType;
        this.desc = desc;
    }
}

