/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.insurance;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum InsuranceAccountTypeEnum {
    SUPER_ADMIN(1, "\u8d85\u7ea7\u7ba1\u7406\u5458", 1),
    ADMIN(2, "\u516c\u53f8\u7ba1\u7406\u5458", 2),
    SALESMAN(3, "\u5750\u5e2d", 5),
    AUDITOR(4, "\u5ba1\u6838\u4eba\u5458", 4),
    VERIFY(5, "\u9a8c\u771f\u4eba\u5458", 5),
    INSTITUTION(6, "\u673a\u6784\u7ba1\u7406\u5458", 3);

    private final Integer type;
    private final String desc;
    private final Integer level;
    private static final Map<Integer, InsuranceAccountTypeEnum> ENUM_MAP;

    public static InsuranceAccountTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getLevel() {
        return this.level;
    }

    private InsuranceAccountTypeEnum(Integer type, String desc, Integer level) {
        this.type = type;
        this.desc = desc;
        this.level = level;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(InsuranceAccountTypeEnum.values()).collect(Collectors.toMap(InsuranceAccountTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

