package cn.com.duiba.quanyi.center.api.enums.car;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:30
 */
@Getter
@AllArgsConstructor
public enum CarSerCouponBizTypeEnum {
    EQUITY_ADD(1, "权益新增"),
    EQUITY_EDIT(2, "权益编辑"),
    EQUITY_CHANGE_GRANT_PHONE(3, "变更发放账号"),
    EQUITY_DELETE(4, "权益删除"),
    ADDITIONAL_EQUITY(5, "追加权益"),
    ACTIVITY_GRANT(6, "活动发放"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, CarSerCouponBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CarSerCouponBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static CarSerCouponBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
