package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiJointConfigExtDto;

import java.util.List;
import java.util.Map;

/**
 * API供给配置扩展表
 * @author kjj mybatis generator 
 * @date 2024-07-03
 */
@AdvancedFeignClient
public interface RemoteApiJointConfigExtService {

    /**
     * 根据对接配置Id查询
     * @param apiJointId 对接配置Id
     * @return API供给配置扩展
     */
    List<ApiJointConfigExtDto> selectByApiJointId(Long apiJointId);

    /**
     * 根据对接配置Id查询
     * @param apiJointId 对接配置Id
     * @return key:confName, value:confValue
     */
    Map<Integer, String> selectMapByApiJointId(Long apiJointId);

    /**
     * 根据对接配置Id批量查询
     * @param apiJointIds 对接配置Id
     * @return key:confName, value:confValue
     */
    Map<Long, Map<Integer, String>> selectMapByApiJointIds(List<Long> apiJointIds);
}