package cn.com.duiba.quanyi.center.api.dto.equity.coupon;

import cn.com.duiba.quanyi.center.api.enums.equity.coupon.EquityCouponOrderStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 权益券订单
 * @author mybatis generator 
 * @date 2024-08-05
 */
@Data
public class EquityCouponOrderDto implements Serializable {
     
    private static final long serialVersionUID = 17228461835663290L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 权益券单号
     */
    private String couponOrderNo;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 券ID
     */
    private Long couponId;

    /**
     * 券编码
     */
    private String couponCode;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动奖品ID
     */
    private Long prizeId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 门店ID
     */
    private Long storeId;

    /**
     * 门店服务ID
     */
    private Long storeSerId;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 支付订单号
     */
    private String bizOrderNo;

    /**
     * 发放订单号
     */
    private String goodsOrderNo;

    /**
     * 订单状态
     * @see EquityCouponOrderStatusEnum
     */
    private Integer orderStatus;
}