package cn.com.duiba.quanyi.center.api.dto.equity.coupon;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.equity.coupon.EquityCouponStateEnum;
import lombok.Data;

/**
 * 权益券表
 * @author mybatis generator 
 * @date 2024-08-05
 */
@Data
public class EquityCouponDto implements Serializable {
     
    private static final long serialVersionUID = 17228461835548495L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 券唯一编码
     */
    private String couponCode;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动奖品ID
     */
    private Long prizeId;

    /**
     * 权益券名称
     */
    private String couponName;

    /**
     * 权益券图片
     */
    private String couponImg;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * 服务编码
     */
    private String dbCode;

    /**
     * 需要支付的金额，单位分
     */
    private Long payAmount;

    /**
     * 生效时间
     */
    private Date effectiveTime;

    /**
     * 到期时间
     */
    private Date expireTime;

    /**
     * 券状态
     * @see EquityCouponStateEnum
     */
    private Integer couponState;

    /**
     * 是否限定车牌号
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer limitCarNumber;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 关联的保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 关联的权益ID
     */
    private Long insuranceEquityId;

    /**
     * 关联的业务订单号
     */
    private String bizGoodsOrderNo;
}