package cn.com.duiba.quanyi.center.api.enums.equity.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/8/5 16:30
 */
@Getter
@AllArgsConstructor
public enum EquityCouponStateEnum {
    // 券状态：1-待兑换(兑换失败、核销过期、券退回)，2-兑换中，3-兑换失败，4-待核销，5-已核销，6-兑换过期，7-核销过期
    NOT_TAKE(1, "待兑换"),
    TAKE_PROCESSING(2, "兑换中"),
    TAKE_SUCCESS(3, "待核销"),
    VERIFICATION(4, "已核销"),
    TAKE_EXPIRED(5, "兑换过期"),
    INVALID(6, "已作废"),
    ;
    
    private final Integer state;
    
    private final String desc;
}
