package cn.com.duiba.quanyi.center.api.remoteservice.equity.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.equity.coupon.EquityCouponOrderDto;

import java.util.List;

/**
 * 权益券订单
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@AdvancedFeignClient
public interface RemoteEquityCouponOrderService {
    /**
     * 根据用户id和状态分页查询
     * @param userId 用户id
     * @param orderStatus 状态
     * @param lastId 最后一条数据的id
     * @param pageSize 每页条数
     * @return 权益券订单列表
     */
    List<EquityCouponOrderDto> selectByUserIdAndStatusPage(Long userId, Integer orderStatus, Long lastId, Integer pageSize);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 权益券订单
     */
    EquityCouponOrderDto selectById(Long id);
}