package cn.com.duiba.quanyi.center.api.remoteservice.equity.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.equity.coupon.EquityCouponDto;
import cn.com.duiba.quanyi.center.api.param.PageQuery;

import java.util.List;

/**
 * 权益券表
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@AdvancedFeignClient
public interface RemoteEquityCouponService {

    /**
     * 根据手机号和状态查询权益券数量
     *
     * @param accountPhone 手机号
     * @param states       状态集合
     * @return 权益券数量
     */
    long selectCountByAccountPhoneAndStates(String accountPhone, List<Integer> states);

    /**
     * 根据权益ID查询权益券
     *
     * @param equityId 权益ID
     * @return 权益券
     */
    List<EquityCouponDto> selectByEquityId(Long equityId);

    /**
     * 根据手机号分页查询
     *
     * @param accountPhone 手机号
     * @param pageQuery 分页参数
     * @return 权益券列表
     */
    List<EquityCouponDto> selectByAccountPhonePage(String accountPhone, PageQuery pageQuery);
}