package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 抖音支付券创建/编辑参数
 */
@Data
public class DouYinActivitySaveOrUpdateParam implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动有效期开始时间
     */
    private Date activityBeginTime;

    /**
     * 活动有效期结束时间
     */
    private Date activityEndTime;

    /**
     * 每个账号每日可领数量
     */
    private Integer dailyLimit;

    /**
     * 每个账号活动周期内可领数量
     */
    private Integer validityPeriodLimit;

    /**
     * 抖音批次号
     */
    private String stockId;

    /**
     * 批次状态 INIT-待启动,INAP-待审批,VALID-生效,SUSPEND-暂定,INVALID-失效
     */
    private String stockStatus;

    /**
     * 活动预算，单位 分
     */
    private Integer budget;

    /**
     * 券批次出资方式 charge-预充值
     */
    private String fundType;

    /**
     * 银行卡渠道 DEBIT-借记卡，CREDIT-贷记卡
     */
    private String bankChannel;

    /**
     * 卡 bin
     */
    private String limitedBins;

    /**
     * 券类型 MJ-满减
     */
    private String stockType;

    /**
     * 券的优惠金额 单位 分
     */
    private Integer reduceAmount;

    /**
     * 券的使用门槛金额 单位 分
     */
    private Integer reachedAmount;

    /**
     * 券的总发放张数
     */
    private Integer totalNum;

    /**
     * 有效期生效类型,
     * ABSOLUTE:固定有效期，指券领取后在配置的固定时间段内有效,
     * RELATIVE:相对有效期，指券领取后在配置的相对有效期内有效，可选relative_start_type字段的三种方式,TODAY:当天有效，指券领取时到领券当天23:59:59内有效
     */
    private String validType;

    /**
     * 当券使用有效期类型为相对有效期(RELATIVE)时必填，
     * NOW:立即生效，指券领取后立即生效，
     * NEXT:第二天凌晨生效，指券领取后第二天凌晨生效，
     * NDAY:第N天凌晨生效，指券领取后从配置的第N天凌晨生效
     */
    private String relativeStartType;

    /**
     * 有效期生效天数,relative_start_type=NDAY时必填,第n天凌晨生效,2<=n<=30
     */
    private Integer relativeStartDays;

    /**
     * 相对有效期生效时长,相对有效期生效时长，秒级别时间
     */
    private Integer validRelativeSeconds;

    /**
     * 是否支持退款退券,(Y:支持,N:不支持)
     */
    private String isRefundCoupon;

    /**
     * 固定有效期券有效期开始时间
     */
    private Date validBeginTime;

    /**
     * 固定有效期券有效期结束时间
     */
    private Date validEndTime;

    /**
     * 券简要使用说明
     */
    private String shortDesc;

    /**
     * 券详细使用说明
     */
    private String description;

    /**
     * 背景图
     */
    private String bgUrl;

    /**
     * logo
     */
    private String logoUrl;

    /**
     * 跳转链接
     */
    private String jumpUrl;

    /**
     * 已发放数量
     */
    private Integer useNum;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 创建批次的商户号
     */
    private String stockCreatorMchId;

    /**
     * 是否需要告警，0-不需要，1-需要
     */
    private Integer needWarn;

    /**
     * 1启用 0未启用
     */
    private Integer enableStatus;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 用户领券后有效期为多少天，用于告警
     */
    private Integer userValidityPeriod;

    /**
     * 业务状态, 1-待分配, 2-已分配
     */
    private Integer bizStatus;

    /**
     * 资金使用率，-1代表无法计算
     */
    private Integer fundUseRate;

    /**
     * 面额类型：1-固定，2-不固定
     */
    private Integer amountType;

    /**
     * 不固定面额：最小面额，单位分
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大面额，单位分
     */
    private Long rangeMaxAmount;

    /**
     * 需求预算 分
     */
    private Integer demandBudget;

    /**
     * 是否自动加款 0-否 1-是
     */
    private Integer autoAddMoney;

    /**
     * 是否自动创建 0-否 1-是
     */
    private Integer autoCreate;
}
