package cn.com.duiba.quanyi.center.api.dto.coupon;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 抖音支付券活动关联 dto
 */
@Data
public class DouYinCouponActivityDto implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 抖音支付券主键,tb_wx_douyin.id
     */
    private Long douyinCouponId;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;
    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 活动类型
     *
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 发放开始时间
     */
    private Date grantStartTime;

    /**
     * 发放结束时间
     */
    private Date grantEndTime;
}
