package cn.com.duiba.quanyi.center.api.dto.statistic;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同统计表
 * @author mybatis generator 
 * @date 2024-07-18
 */
@Data
public class ContractStatisticDto implements Serializable {
     
    private static final long serialVersionUID = 1721296143164235L;

    /**
     * 唯一标识，每条记录一个唯一值
     */
    private Long id;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 合同累积采购金额（含服务费）
     */
    private Long totalPurchaseAmountWithServiceFee;

    /**
     * 合同累计采购总额（不含服务费）
     */
    private Long totalPurchaseAmountWithoutServiceFee;

    /**
     * 合同累计应收账款（含服务费）
     */
    private Long totalReceivablesWithServiceFee;

    /**
     * 合同累计核销净额（不含服务费）
     */
    private Long totalVerifiedNetAmountWithoutServiceFee;

    /**
     * 已开票金额（含服务费）
     */
    private Long invoicedAmountWithServiceFee;

    /**
     * 已打款金额（含服务费
     */
    private Long paidAmountWithServiceFee;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}