package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.DouYinCouponStockDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponStockDto;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDouYinCouponStockService {


    /**
     * 根据抖音支付券主键查询
     *
     * @param douyinCouponId
     * @return
     */
    DouYinCouponStockDto selectByDouYinCouponId(Long douyinCouponId);

    /**
     * 根据抖音支付券主键批量查询
     *
     * @param douyinCouponIds 抖音支付券ID集合
     * @return key：立减金ID，value：抖音支付券库存
     */
    Map<Long, DouYinCouponStockDto> selectByDouYinCouponIdList(List<Long> douyinCouponIds);
}
