package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author xuzhigang
 * @date 2024/4/24 14:06
 **/
@Getter
@AllArgsConstructor
public enum DirectPayMethodEnum {
    NOT_SPECIFIED(0, "不指定"),

    BANK_CARD(1, "银行卡"),

    SMALL_CHANGE(2, "零钱"),
    ;

    private final int code;

    private final String desc;

    public static boolean isValidPayMethod(int code) {
        return Arrays.stream(values()).anyMatch(t -> t.getCode() == code);
    }

    public static DirectPayMethodEnum getByCode(int code) {
        return Arrays.stream(values()).filter(t -> t.getCode() == code).findFirst().orElse(null);
    }
}
