package cn.com.duiba.quanyi.center.api.enums.pay;

import cn.com.duiba.kjy.paycenter.api.enums.PayTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 支付渠道
 * @author lizhi
 * @date 2023/10/22 11:37
 */
@AllArgsConstructor
@Getter
public enum PayChannelTypeEnum {

    WX_LITE("wx_lite", "微信小程序支付"),
    CCB_PAY("ccb_pay", "建设银行数字货币H5"),
    ALIPAY_WAP_PAY("alipay_wap_pay","支付宝手机网站支付2.0"),

    ALIPAY_WAP_PAY_FACE("alipay_ftf_jsapi","支付宝当面付"),
    INSURANCE_FUND("insurance_fund", "保司账户余额"),
    HZ_BANK_PAY("hz_bank_pay", "杭州银行支付"),

    MINSHENG_PAY("minsheng_pay", "全民生活APP收银台"),
    WX_PUB("wx_pub", "微信公众号支付"),


    ;

    private final String channelType;
    
    private final String channelName;


    private static final Map<String, PayChannelTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PayChannelTypeEnum::getChannelType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static PayChannelTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
    
}
