package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 保司公司资金变更记录表
 * @author mybatis generator 
 * @date 2024-07-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceCompanyFundChangeRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17211857742723316L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 公司ID，tb_tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 变更类型，1-支出, 2-收入
     */
    private Byte changeType;

    /**
     * 业务类型，1-资金调整，2-新增权益，3-编辑权益，4-删除权益
     */
    private Byte bizType;

    /**
     * 业务关联ID
     */
    private Long bizId;

    /**
     * 变更金额，单位分
     */
    private Long changeAmount;

    /**
     * 操作人手机号
     */
    private String operatorPhone;

    /**
     * 变更参数json
     */
    private String changeParam;
}