package cn.com.duiba.quanyi.center.api.param.coupon.notify;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2024/7/25 16:50
 **/
@Data
public class AlipayActivityPublishResultNotifyParam implements Serializable {

    private static final long serialVersionUID = 5866582572617686719L;

    /**
     * 活动id
     */
    @NotBlank(message = "活动id不能为空")
    private String activityId;

    /**
     * 发布结果 true-成功 false-失败
     */
    @NotNull(message = "发布结果不能为空")
    private Boolean result;

    /**
     * 错误原因
     */
    private String errorMsg;
}
