package cn.com.duiba.quanyi.center.api.remoteservice.insurance.equity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceBlacklistDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceBlacklistSearchParam;
import java.util.List;

/**
 * 保司黑名单表
 * @author kjj mybatis generator 
 * @date 2024-08-20
 */
@AdvancedFeignClient
public interface RemoteInsuranceBlacklistService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司黑名单集合
     */
    List<InsuranceBlacklistDto> selectPage(InsuranceBlacklistSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceBlacklistSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司黑名单
     */
    InsuranceBlacklistDto selectById(Long id);

    /**
     * 新增
     * @param dto 保司黑名单
     * @return 执行结果
     */
    int insert(InsuranceBlacklistDto dto);

    /**
     * 更新
     * @param dto 保司黑名单
     * @return 影响行数
     */
    int update(InsuranceBlacklistDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据公司ID删除数据
     * @param companyId
     * @return
     */
    int deleteByCompanyId(Long companyId);

    /**
     * 批量插入
     * @param list
     * @return
     */
    int batchInsert(List<InsuranceBlacklistDto> list);
}