package cn.com.duiba.quanyi.center.api.remoteservice.insurance.institution;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.institution.InsuranceTakeProxyAccountDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeProxyAccountSearchParam;
import java.util.List;

/**
 * 保司代领人账户管理表
 * @author kjj mybatis generator 
 * @date 2024-03-21
 */
@AdvancedFeignClient
public interface RemoteInsuranceTakeProxyAccountService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保司代领人账户管理集合
     */
    List<InsuranceTakeProxyAccountDto> selectPage(InsuranceTakeProxyAccountSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceTakeProxyAccountSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司代领人账户管理
     */
    InsuranceTakeProxyAccountDto selectById(Long id);

    /**
     * 新增
     * @param dto 保司代领人账户管理
     * @return 执行结果
     */
    int insert(InsuranceTakeProxyAccountDto dto);

    /**
     * 更新
     * @param dto 保司代领人账户管理
     * @return 影响行数
     */
    int update(InsuranceTakeProxyAccountDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @param operatorPhone 操作人
     * @return 执行结果
     */
    int delete(Long id, String operatorPhone);
}