/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.pay;

import cn.com.duiba.quanyi.center.api.enums.pay.PayStatusEnum;

public enum PayResultStatusEnum {
    PROCESS(1, "\u5904\u7406\u4e2d"),
    SUCCESS(2, "\u6210\u529f"),
    FAIL(3, "\u5931\u8d25"),
    CANCEL(4, "\u53d6\u6d88"),
    REFUNDING(5, "\u9000\u6b3e\u4e2d"),
    REFUND_SUCCESS(6, "\u9000\u6b3e\u6210\u529f");

    private final Integer status;
    private final String desc;

    public static PayResultStatusEnum getByPayStatus(Integer payStatus) {
        PayStatusEnum statusEnum = PayStatusEnum.getByCode(payStatus);
        switch (statusEnum) {
            case ORDER_FAIL: 
            case PAY_FAIL: {
                return FAIL;
            }
            case PAY_SUCCESS: {
                return SUCCESS;
            }
            case PAY_REVERSED: {
                return CANCEL;
            }
            case REFUND_SUCCESS: {
                return REFUND_SUCCESS;
            }
            case REFUNDING: 
            case REFUND_FAIL: {
                return REFUNDING;
            }
        }
        return PROCESS;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private PayResultStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }
}

