package cn.com.duiba.quanyi.center.api.param.channel;

import lombok.Data;

import java.io.Serializable;

/**
 * 小程序二维码生成参数
 * @author lizhi
 * @date 2023/8/7 17:16
 */
@Data
public class MpQrCodeCreateParam implements Serializable {
    
    private static final long serialVersionUID = -7243314197073000659L;

    /**
     * 业务类型（当wxAppId不为空时，以wxAppId为准）
     * @see cn.com.duiba.quanyi.center.api.enums.user.OaBizTypeEnum
     */
    private Integer bizType;

    /**
     * 小程序appId
     */
    private String wxAppId;
    
    /**
     * 场景值。即扫码回调参数。<br/>
     * 最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~<br/>
     * 其它字符请自行编码为合法字符（因不支持%，中文无法使用 urlencode 处理，请使用其他编码方式）<br/>
     */
    private String scene;

    /**
     * 扫码跳转小程序页面。<br/>
     * 1、必须是已经发布的小程序存在的页面（否则报错）<br/>
     * 2、不能携带参数<br/>
     * 3、不要以/开头<br/>
     * 4、为空时跳转主页面<br/>
     */
    private String page;

    /**
     *
     * 图片宽度。正方形，宽高相同<br/>
     * 单位：px<br/>
     * 默认值：430px<br/>
     * 最小 280px<br/>
     * 最大 1280px<br/>
     */
    private int width = 430;

    /**
     * 是否需要透明底色，为 true 时，生成透明底色的小程序
     * 默认：false
     */
    private boolean hyaline;

    /**
     * 要打开的小程序版本。正式版为 "release"，体验版为 "trial"，开发版为 "develop"。默认是正式版。
     */
    private String envVersion = "x";
}
