package cn.com.duiba.quanyi.center.api.param.mall.goods;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 商城商品sku
 * @author mybatis generator 
 * @date 2024-05-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MallSkuSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17166079492704507L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Byte logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 是否启用
     */
    private Byte enableStatus;

    /**
     * 商城商品ID
     */
    private Long mallSpuId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 商品库spuId
     */
    private Long spuId;

    /**
     * 商品库skuId
     */
    private Long skuId;

    /**
     * 商品类型
     */
    private Integer spuType;

    /**
     * sku图片
     */
    private String mallSkuImg;

    /**
     * 划线价，单位分
     */
    private Long marketPrice;

    /**
     * 售卖价，单位分
     */
    private Long sellPrice;

    /**
     * 兑换价，单位分
     */
    private Long takePrice;

    /**
     * 规格配置 json
     */
    private String attrConf;
}