package cn.com.duiba.quanyi.center.api.remoteservice.qy.signing;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.signing.SigningDto;
import cn.com.duiba.quanyi.center.api.param.qy.signing.SigningSearchParam;
import java.util.List;
import java.util.Set;

/**
 * 签约信息表
 * @author kjj mybatis generator 
 * @date 2024-05-09
 */
@AdvancedFeignClient
public interface RemoteSigningService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 签约信息集合
     */
    List<SigningDto> selectPage(SigningSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SigningSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 签约信息
     */
    SigningDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键集合
     * @return 签约信息
     */
    List<SigningDto> selectByIds(Set<Long> ids);


    /**
     * 根据身份证和姓名查询
     * @param idCard
     * @param userName
     * @return
     */
    SigningDto selectByIdCardAndName(String idCard,String userName);

    /**
     * 根据身份证和姓名,商户号查询
     * @param idCard
     * @param userName
     * @return
     */
    SigningDto selectByIdCardAndNameAndMchId(String idCard, String userName, String mchId);

    /**
     * 新增
     * @param dto 签约信息
     * @return 执行结果
     */
    Long insert(SigningDto dto);

    /**
     * 更新
     * @param dto 签约信息
     * @return 影响行数
     */
    int update(SigningDto dto);
}