package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityStaffDetailDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityStaffDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityStaffPageQueryParam;

import java.util.List;
import java.util.Set;

/**
 * 活动员工信息表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityStaffService {

    /**
     * 根据主键查询（不包含已删除的）
     *
     * @param id 主键
     * @return 活动员工信息
     */
    ActivityStaffDto selectById(Long id);

    /**
     * 新增或更新
     *
     * @param detailDto 活动员工信息
     * @return 执行结果
     */
    Long saveOrUpdate(ActivityStaffDetailDto detailDto);

    /**
     * 新增
     *
     * @param activityStaffDto 活动员工信息
     * @return 执行结果
     */
    @Deprecated
    Long insert(ActivityStaffDto activityStaffDto);

    /**
     * 批量新增，并获取已经存在的手机号
     * @param activityId 活动ID
     * @param list 客户经理集合
     * @return 已经存在的手机号集合
     */
    Set<String> batchInsertAndGetExistPhones(Long activityId, List<ActivityStaffDto> list);

    /**
     * 批量新增
     *
     * @param list 活动员工信息
     * @return 执行结果
     */
    int batchInsert(List<ActivityStaffDto> list);
    
    /**
     * 更新
     *
     * @param activityStaffDto 活动员工信息
     * @return 执行结果
     */
    @Deprecated
    int update(ActivityStaffDto activityStaffDto);

    /**
     * 根据活动及手机号查询（不包含已删除的）
     *
     * @param activityId 活动id
     * @param staffPhone 员工手机号
     * @return 活动员工信息
     */
    ActivityStaffDto selectByActivityPhone(Long activityId, String staffPhone);

    /**
     * 根据活动及用户查询（不包含已删除的）
     *
     * @param activityId 活动id
     * @param userId     用户id
     * @return 活动员工信息
     */
    ActivityStaffDto selectByActivityUser(Long activityId, Long userId);

    /**
     * 根据用户ID查询（不包含已删除的）
     *
     * @param userId 用户ID
     * @return 活动员工信息
     */
    List<ActivityStaffDto> selectByUserId(Long userId);

    /**
     * 用户已绑定活动的数量（不包含已删除的）
     *
     * @param userId 用户ID
     * @return 绑定活动的数量
     */
    long countActivityByUserId(Long userId);

    /**
     * 根据活动id批量查询（不包含已删除的）
     *
     * @param param
     * @return 活动员工信息
     */
    List<ActivityStaffDto> findPageByActivityId(ActivityStaffPageQueryParam param);

    /**
     * 根据活动id count（不包含已删除的）
     *
     * @param activityId
     * @return count
     */
    Integer countByActivityId(Long activityId);

    /**
     * 筛选管理员添加的员工（不包含已删除的）
     *
     * @param activityId   活动id
     * @param operatorType 操作人类型（可为空）
     * @param operatorId   操作人id（可为空）
     * @param lastId       分页序号（可为空）
     * @param pageSize     分页大小
     * @return 活动白名单
     */
    List<ActivityStaffDto> selectPageByActivityIdAndOpId(Long activityId, Integer operatorType, Long operatorId, Long lastId, Integer pageSize);


    /**
     * 绑定客户经理用户
     *
     * @param activityId 活动id
     * @param staffPhone 员工手机号
     * @param userId 绑定的用户id
     * @return 执行结果
     */
    int bindUser(Long activityId, String staffPhone, Long userId);

    /**
     * 解绑客户经理用户
     *
     * @param activityId 活动id
     * @param staffPhone 员工手机号
     * @return
     */
    int unbindUser(Long activityId, String staffPhone);


    /**
     * 删除
     *
     * @param id
     * @return
     * @deprecated 使用deleteNew
     */
    @Deprecated
    int delete(Long id);


    /**
     * 软删除
     *
     * @param id           主键
     * @param operatorType 操作人类型
     * @param operatorId   操作人id
     * @param operatorName 操作人名字
     * @return 执行结果
     */
    int deleteNew(Long id, Integer operatorType, Long operatorId, String operatorName);
}