package cn.com.duiba.quanyi.center.api.dto.equity.coupon;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.equity.coupon.EquityCouponBizTypeEnum;
import lombok.Data;

/**
 * 权益券变更记录表
 * @author mybatis generator 
 * @date 2024-08-05
 */
@Data
public class EquityCouponChangeRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17228461835624430L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 手机号
     */
    private String accountPhone;

    /**
     * 变更类型
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceFundChangeTypeEnum
     */
    private Integer changeType;

    /**
     * 业务类型
     * @see EquityCouponBizTypeEnum
     */
    private Integer bizType;

    /**
     * 关联业务唯一标识
     */
    private String bizNo;

    /**
     * 权益券编码
     */
    private String couponCode;

    /**
     * 变更备注
     */
    private String changeRemark;
}