package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author xuzhigang
 * @date 2024/7/30 15:20
 **/
@Getter
@AllArgsConstructor
public enum GamePlaySingleTypeEnum {
    FIXED_REDUCE(1, "定额立减"),
    DISCOUNT_REDUCE(2, "折扣立减"),
    SMART_REDUCE(3, "智能立减"),
    ;

    private Integer type;
    private String desc;

    public static GamePlaySingleTypeEnum getByType(Integer type) {
        return Arrays.stream(GamePlaySingleTypeEnum.values()).filter(o -> Objects.equals(type, o.getType())).findFirst().orElse(null);
    }
}
