package cn.com.duiba.quanyi.center.api.enums.equity.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/8/5 16:30
 */
@Getter
@AllArgsConstructor
public enum EquityCouponStateEnum {
    // 券状态：1-待兑换(兑换失败、核销过期、券退回)，2-兑换中，3-兑换失败，4-待核销，5-已核销，6-兑换过期，7-核销过期
    NOT_TAKE(1, "待兑换"),
    TAKE_PROCESSING(2, "兑换中"),
    TAKE_SUCCESS(3, "待核销"),
    VERIFICATION(4, "已核销"),
    TAKE_EXPIRED(5, "兑换过期"),
    VERIFICATION_EXPIRE(6, "核销过期"),
    INVALID(7, "已作废"),
    ALREADY_TAKE(8, "已兑换"),
    ;
    
    private final Integer state;
    
    private final String desc;
    
    public String logStr() {
        return state + "-" + desc;
    }
    
    private static final Map<Integer, EquityCouponStateEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(EquityCouponStateEnum::getState, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param state 枚举值
     * @return 枚举
     */
    public static EquityCouponStateEnum getByState(Integer state) {
        if (state == null) {
            return null;
        }
        return ENUM_MAP.get(state);
    }
}
